if Facter.value(:kernel) == 'Linux' and Facter.value(:id) == 'root'
  # search for teamdctl
  if Facter::Core::Execution.which('teamdctl') != nil
    # default gateway interface needs will be team or bond
    intf = Facter.value(:default_gateway_interface)
    begin
      team_state = JSON.parse(Facter::Core::Execution.exec("teamdctl #{intf} state dump 2>/dev/null").chomp)
    rescue JSON::ParserError
    else
      if !team_state.nil? && !team_state['ports'].nil?
        Facter.add("teaming_#{intf}_slaves".to_sym) { setcode { team_state['ports'].keys.join(',') } }
      end
    end
  end
end
