#
# pretty_json.rb
#
# Take a puppet hash and convert it into a pretty json string
# This is taken from https://gist.github.com/falzm/8575549

require 'json'
 
def sorted_json(obj)
  case obj
    when String, Fixnum, Float, TrueClass, FalseClass, NilClass
      return obj.to_json
    when Array
      arrayRet = []
      obj.each do |a|
        arrayRet.push(sorted_json(a))
      end
      return "[" << arrayRet.join(',') << "]";
    when Hash
      ret = []
      obj.keys.sort.each do |k|
        ret.push(k.to_json << ":" << sorted_json(obj[k]))
      end
      return "{" << ret.join(",") << "}";
    else
      raise Puppet::Error, "Unable to pretty_json object of type <#{obj.class.to_s}>"
  end
end
 
module Puppet::Parser::Functions
  newfunction(:pretty_json, :type => :rvalue, :doc => <<-EOS
This function takes data, outputs making sure the hash keys are sorted
 
*Examples:*
 
    pretty_json({'key'=>'value'})
 
Would return: {'key':'value'}
    EOS
  ) do |arguments|
    raise(Puppet::ParseError, "pretty_json(): Wrong number of arguments " +
      "given (#{arguments.size} for 1)") if arguments.size != 1
 
    json = arguments[0]
    begin
      return sorted_json(json)
    rescue Exception => e 
      raise(Puppet::ParseError, e.message)
    end
  end
end
