class gatekeeper (
  $ensure           = $gatekeeper::params::ensure,

  $gomaxprocs       = $gatekeeper::params::gomaxprocs,
  $env              = $gatekeeper::params::env,
  $enable_edgeevent = $gatekeeper::params::enable_edgeevent,
  $extra_flags      = $gatekeeper::params::extra_flags,

  $stats_group      = $gatekeeper::params::stats_group,
  $statsd_host      = $gatekeeper::params::statsd_host,
  $statsd_port      = $gatekeeper::params::statsd_port,

  # For Courier
  $basedir          = $gatekeeper::params::basedir,
  $project          = $gatekeeper::params::project,

  $node_name        = $gatekeeper::params::node_name,
  $host_name        = $gatekeeper::params::host_name,
) inherits gatekeeper::params {

  require milliner
  validate_re($ensure, [ '^present$', '^absent$' ])
  validate_bool($enable_edgeevent)
  validate_absolute_path($basedir)
  validate_re($project,'[A-Za-z0-9_]/[A-Za-z0-9_]')
  validate_string($host_name, $node_name)

  if $ensure == 'present' {
    # The consul registration for the service is in gatekeeper::instance
    courier::install{ 'gatekeeper':
      env     => $env,
      repo    => $project,
      basedir => $basedir,
      require => [
        Gatekeeper::Instance['gatekeeper'],
        Gatekeeper::Instance['gatekeeper_backup'],
        Class['courier'],
      ]
    }
  }

  gatekeeper::instance {
    'gatekeeper':
      ensure       => $ensure,
      public_addr  => $primary_public_addr,
      private_addr => $primary_private_addr,
      sock_name    => 'gatekeeper.sock',
      env          => $env;

    'gatekeeper_backup':
      ensure       => $ensure,
      public_addr  => $backup_public_addr,
      private_addr => $backup_private_addr,
      sock_name    => 'gatekeeper_backup.sock',
      backup       => true,
      env          => $env;
  }
}
