class gatekeeper::params {
  $ensure               = 'present'

  $gomaxprocs           = 6
  $env                  = pick($twitch_environment, $::twitch_environment)  # For deciding the consul environment
  $enable_edgeevent     = true
  $extra_flags          = {}

  $host_name            = "${hostname_1}.hls.justin.tv"
  $node_name            = "${hostname}.${pop}"
  $mode                 = 'edge'

  $primary_public_addr  = ':4555'
  $primary_private_addr = ':4666'
  $backup_public_addr   = ':4556'
  $backup_private_addr  = ':4667'

  $stats_group          = $::pop
  $statsd_host          = hiera('statsd_host', 'statsd.internal.justin.tv')
  $statsd_port          = hiera('statsd_port', 8125)

  $basedir              = '/opt/twitch'
  $project              = 'video/gatekeeper'
}
