# Sets up the goingest service.

class goingest (
  $goingest_ensure   = $goingest::params::goingest_ensure,
  $goingest_env      = $goingest::params::goingest_env,
  $goingest_path     = $goingest::params::goingest_path,
  $goingest_stage    = $goingest::params::goingest_stage,
  $goingest_substage = $goingest::params::goingest_substage,
  $bind_ip           = $::ipaddress_primary,
  $concat_flags      = join(hiera_array('goingest::flags', []), ' ')
) inherits goingest::params {

  if $goingest_env == undef {
    fail('You must supply a value for $goingest_env (or the consul module freaks out).')
  }

  # static, shared args.
  $goingest_args = [
    "-listen-ip=${bind_ip}",
    "-node-name=${::hostname_1}",
    "-pop=${::pop}",
    "-stage=${goingest_stage}",
    "-substage=${goingest_substage}",
  ]
  # set to default system file limit
  $limit_nofile = 262144

  case $::lsbdistcodename {
    'xenial': {  # VIDCS-2715 remove xenial case once converted
      # TODO: change hostname_1 to fqdn some day
      $goingest_exec = ['setuidgid nobody',
        './goingest'
      ]
      $goingest_cmd = join(concat(
        $goingest_exec,
        $goingest_args,
        $concat_flags,
        '2>&1')
        , ' ')

      daemontools::supervise { 'goingest':
        daemon         => $goingest_cmd,
        wd             => $goingest_path,
        predaemon      => [template("${module_name}/predaemon.erb")],
        restart_signal => 'HUP',
        syslog         => 'local5'
      }
    }
    default: {
        # 3/4ths of pid_max. pid_max is 1024 * processorcount
        $tasks_max = 3 * (1024 * $::processorcount) / 4
        $goingest_exec = ["${goingest_path}/goingest"]
        $goingest_cmd = join(concat(
          $goingest_exec,
          $goingest_args,
          $concat_flags)
          , ' ')

        twitch_systemd::unit_file { 'goingest.service':
          ensure  => $goingest_ensure,
          content => template("${module_name}/goingest.service.erb"),
        }
    }
  }

  # Configure logging (with lhr05 mapping override)
  if $::pop == 'lhr05' {
    twitch_svclogs::logfile { 'goingest':
      ensure             => $goingest_ensure,
      use_default_region => false,
      region             => 'eu-west-2',
      log_group_name     => "/goingest/${::pop}/${goingest_stage}/${goingest_substage}",
      datetime_format    => '%Y-%m-%dT%H:%M:%S.%f',
    }
  } else {
    twitch_svclogs::logfile { 'goingest':
      ensure             => $goingest_ensure,
      use_default_region => true,
      log_group_name     => "/goingest/${::pop}/${goingest_stage}/${goingest_substage}",
      datetime_format    => '%Y-%m-%dT%H:%M:%S.%f',
    }
  }

  # TODO: consul doesn't currently support advertising alternative IPs for a
  # box. Once that feature is added bind this to the correct IP.

  consul::service { 'goingest':
    consul_tags => [$goingest_env],
    port        => 1935,
  }

  consul::service { 'goingest-tls':
    consul_tags => [$goingest_env],
    port        => 1943,
  }
}
