class gvc_aws::install inherits gvc_aws {
  if str2bool($is_canary) {
    $consul_tags = [$deploy_env, "${deploy_env}-canary"]
  } else {
    $consul_tags = [$deploy_env]
  }

  consul::service { 'deploy-target-gvc-aws':
    consul_tags => $consul_tags,
  }

  courier::install { 'gvc-aws':
    env     => $deploy_env,
    repo    => "video/gvc-aws",
    require => Consul::Service['deploy-target-gvc-aws'],
  }

  daemontools::supervise { 'gvc-aws':
    daemon_dir     => '/var/lib/service',
    user           => 'nobody',
    syslog         => 'local3',
    enable_cgroups => true,
    wd             => '/opt/twitch/gvc-aws/current',
    daemon         => './gvc-aws 2>&1',
    predaemon      => [
      "export ENVIRONMENT=${deploy_env}",
      "export ROLLBAR_TOKEN=${rollbar_token}",
      "export STATSD_HOST_PORT=localhost:8125",
    ]
  }
}