class gvc_aws2::install inherits gvc_aws2 {
  if str2bool($is_canary) {
    $consul_tags = [$deploy_env, "${deploy_env}-canary"]
  } else {
    $consul_tags = [$deploy_env]
  }

  consul::service { 'deploy-target-gvc-aws2':
    consul_tags => $consul_tags,
  }

  courier::install { 'gvc-aws2':
    env     => $deploy_env,
    repo    => "video/gvc-aws2",
    require => Consul::Service['deploy-target-gvc-aws2'],
  }

  daemontools::supervise { 'gvc-aws2':
    daemon_dir     => '/var/lib/service',
    user           => 'nobody',
    syslog         => 'local3',
    enable_cgroups => true,
    wd             => '/opt/twitch/gvc-aws2/current',
    daemon         => './gvc-aws2 2>&1',
    predaemon      => [
      "export ENVIRONMENT=${deploy_env}",
      "export ROLLBAR_TOKEN=${rollbar_token}",
      "export STATSD_HOST_PORT=localhost:8125",
    ]
  }
}