class hlsorigin (
  $svc_name                 = 'hlstr',
  $include_transmuxer       = true,
  $include_transcoder       = true,
  $include_event_transcoder = false,
  $include_tenfoot          = true,
  $stag_rotate              = $hlsorigin::params::stag_rotate,
  $video_origin_listen_port = 8080,
) inherits hlsorigin::params {
  include twitch::codecs
  include twitch::haproxy::backend
  # ensures no haproxy instance named 'hlsorigin'
  include twitch::haproxy::hlsorigin
  include twitch::packages
  include twitch_python::pip::statsd
  include twitch_nginx
  include twitch::crossdomain
  include twitch::nginxips
  include video::archives_dir
  include video_tier1::nginx_graphite
  include logrotate

  $daemontools_check_services = $include_transmuxer ? {
    true  => 'hls_transmuxer hls_transcoder',
    false => 'hls_transcoder',
  }

  twitch_servicecheck::passive { 'server-status':
    command      => "/usr/local/monitor_scripts/check_daemontools_services ${daemontools_check_services}",
    interval     => 1,
    retry        => 2,
  }

  ## video::workers::hls_transcoder/transmuxer work is also done
  ##    in video_origin . so this is redundant except for the nrdp checks
  if $include_transmuxer and $include_transcoder {
    include video::workers::hls_transmuxer
    include video::workers::hls_transcoder
  } elsif $include_transcoder {
    include video::workers::hls_transcoder
  } elsif $include_transmuxer {
    # This shouldn't happen.
    include video::workers::hls_transmuxer
  } elsif $include_event_transcoder {
    include video::workers::hls_event_transcoder
  }

  $stag_rotate_ensure = $stag_rotate ? {
    true    => present,
    default => absent,
  }
  file{'/usr/local/lib/logrotate/logrotate.sh':
    ensure => $stag_rotate_ensure,
    owner  => 'root',
    group  => 'root',
    mode   => '0555',
    source => 'puppet:///modules/logrotate/etc/cron.daily/logrotate',
  }

  cron::job { 'staggered_logrotate':
    ensure      => $stag_rotate_ensure,
    command     => '/usr/local/lib/logrotate/logrotate.sh',
    user        => root,
    hour        => fqdn_rand(23, 'logrotate_hour'),
    minute      => fqdn_rand(59, 'logrotate_minute'),
    environment => ['PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin'],
  }

  realize(Package['libid3tag0'])

  $nginx_conf_dir = $twitch_nginx::params::nginx_conf_dir

  ::twitch_nginx::vhost{ $svc_name:
    content  => template("${module_name}/nginx_${svc_name}.conf.erb"),
  }

  twitch_servicecheck::passive { 'check-procs-nginx':
    command  => '/usr/lib/nagios/plugins/check_procs -w 1:35 -c 1:100 -C nginx',
    interval => 1,
    retry    => 2,
  }
  ## No more tenfoot on vp9
  if $include_tenfoot {
    include tenfoot
  }
  # haproxy for vp9 is taken care of in ::twitch_transcode::vp9::haproxy

  # This service advertises the top-layer haproxy instance.
  consul::service { 'hls-origin':
    port        => $video_origin_listen_port,
    consul_tags => [
      "fqdn=${::fqdn}",
      'production'
    ]
  }

  twitch_servicecheck::passive { 'check-procs-origin':
    command  => '/usr/lib/nagios/plugins/check_procs -w 1:35 -c 1:100 -C origin',
    interval => 1,
    retry    => 2,
  }

  # This is necessary only for the transition from the pre-Tenfoot setup, where nginx listens on 8080, to the
  # post-Tenfoot setup, where haproxy listens on 8080 and nginx listens on 8083.
  Twitch_nginx::Vhost <| |> -> Twitch_haproxy::Backend <| |>

}
