class hose_stats (
  $env         = pick($::twitch_environment, $twitch_environment, 'production'),
  $canary      = false,
  $svcname     = 'hose_stats',
  $user        = 'nobody',
  $nop         = false,
  $offset      = 0,
  $concurrency = 0
) {

  if $nop {
    $noop_flag = '--noop'
  }

  $daemon = "${lsbdistcodename}/run --offset ${offset}"

  twitch::service { 'hose_stats':
    env            => $env,
    canary         => $canary,
    manage_service => true,
    daemon_cmd     => "${daemon} ${noop_flag}",
    predaemon      => ['test -f /etc/profile.d/proxy.sh && source /etc/profile.d/proxy.sh'],
    service_repo   => 'video/hose_stats',
    user           => $user,
    concurrency    => $concurrency
  }
}
