# The hosecli class installs the hose CLI tool and makes it deployable.
class hosecli (
  $env                 = $hosecli::params::hosecli_env,
) inherits hosecli::params {
  consul::service { 'video-hose':
    consul_tags  => [$env],
    service_name => 'video-hose'
  }

  courier::install { 'hose':
    env     => $env,
    repo    => 'video/hose',
    basedir => $hosecli::params::basedir,
  }

  file { '/usr/local/bin/hose':
    ensure => 'link',
    target => '/opt/twitch/hose/current/hose',
  }
}
