class hosesapi::haproxy (
  $instname = 'hosesapi',
  $stats_port = 2001,
  $global_options = {
    'user'    => 'www-data',
    'group'   => 'www-data',
    'daemon'  => '',
    'quiet'   => '',
    'pidfile' => '/var/run/haproxy-hosesapi.pid',
    'maxconn' => '32000',
    'chroot'  => '/var/chroot/haproxy',
    'nbproc'  => '1',
    'log-tag' => 'haproxy_hosesapi',
    'log'     => '127.0.0.1 local3',
    'stats'   => 'socket /var/run/haproxy_hosesapi.stat user root group root mode 666 level operator'
  },
  $defaults_options = {
    'log'     => 'global',
    'mode'    => 'tcp',
    'balance' => 'leastconn',
    'option'  => [
      'tcplog',
      'tcpka',
      'redispatch',
      'contstats'
    ],
  },
) inherits hosesapi {

  twitch_haproxy::instance { $instname:
    defaults_options => $defaults_options,
    global_options   => $global_options,
    stats_port       => $stats_port,
  }

  include hosesapi::hosesapi_listener
}
