class hosesapi::hosesapi_listener (
  $haproxy_instance = 'hosesapi',
  $proxy_name     = 'hosesapi',
  $servers        = [
    'video-hosesapi-prod-8c7040.sjc02.justin.tv',
    'video-hosesapi-prod-8c76dc.sjc02.justin.tv',
    'video-hosesapi-prod-914f20.sjc02.justin.tv',
    'video-hosesapi-prod-a24dd0.sjc02.justin.tv',
  ],
  $listen_port    = 80,
  $remote_port    = 8080,
  $listen_address = '0.0.0.0',
  $server_options = 'check inter 5000',
  $settings       = {
    'mode'   => 'http',
    'option'  => [
      'httpchk GET /health/service',
    ],
    'timeout' => [
      'queue 1000',
      'connect 5000',
      'server 180000',
      'client 180000',
    ],
  },
) {

  twitch_haproxy::listen { 'hosesapi-proxy':
    instance_name       => $haproxy_instance,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options
  }
}
