# Module to install the hosesapi software and service.

class hosesapi (
  $hosesapi_env    = $hosesapi::params::hosesapi_env,
  $canary          = $hosesapi::params::canary,
  $config_path     = $hosesapi::params::config_path,
  $config          = $hosesapi::params::config,
  $addr            = $hosesapi::params::addr,
  # These are all used in the template.
  $db_hosts        = $hosesapi::params::db_hosts,
  $db_name         = $hosesapi::params::db_name,
  $db_user         = $hosesapi::params::db_user,
  $db_pass_key     = $hosesapi::params::db_pass_key,
  $db_concons      = $hosesapi::params::db_concons,
  $log_endpoint    = $hosesapi::params::log_endpoint,
  $log_tags        = $hosesapi::params::log_tags,
  $cache_age_ms    = $hosesapi::params::cache_age_ms,
  $statsd_prefix   = $hosesapi::params::statsd_prefix,
  $darklaunch_envs = $hosesapi::params::darklaunch_envs,
  $use2pc          = $hosesapi::params::use2pc,
) inherits hosesapi::params {
  include hosesapi::haproxy

  $config_file = "${config_path}/${config}"

  file { $config_path:
    ensure => 'directory',
    owner  => 'root',
    group  => 'root',
    mode   => '0644',
  }

  twitch_sandstorm_agent::template { 'hosesdb_password':
    destination     => $config_file,
    restart_command => '/usr/bin/svc -h /etc/service/hosesapi',
    contents        => template("${module_name}/config.json.erb"),
    require         => File[$config_path],
  }

  twitch::service { 'hosesapi':
    env          => $hosesapi_env,
    canary       => $canary,
    daemon_cmd   => "./hosesapi -addr ${addr} -config ${config_file}",
    predaemon    => '',
    service_repo => 'video/hosesapi',
    require      => Twitch_sandstorm_agent::Template['hosesdb_password'],
  }
}
