# Default parameters for the hosesapi service.

class hosesapi::params {
  $hosesapi_env   = pick($::twitch_environment, $twitch_environment, 'production-physical')
  $canary         = false
  $config_path    = '/etc/hosesapi'
  $config         = 'config.json'
  $addr           = ':8080'
  $db_hosts       = [ 'video-networkdb-f00d70.sjc02.justin.tv',
                      'video-networkdb-f00a44.sjc02.justin.tv',
                      'video-networkdb-e474fc.sjc02.justin.tv',
                    ]
  $db_name        = 'network'
  $db_user        = 'usher_readwrite_01'
  $db_pass_key    = 'video/hosesapi/production/hosesdb_password'
  $statsd_host    = 'graphite-ingest.central.twitch.a2z.com:8125'
  $statsd_prefix  = 'video.hosesapi.production-physical'
  # concurrent_connections
  $db_concons     = 62
  # global_log_endpoint
  $log_endpoint   = 'http://globallog.elasticbeanstalk.com'
  # global_log_tags
  $log_tags       = [ 'production', ]
  # max_cache_age_in_ms
  $cache_age_ms   = 200
  $use2pc         = true
  $darklaunch_envs = []
}
