#!/usr/bin/env python
import platform, requests, sys, os

cache_file = '/tmp/goingest-enabled'
class ConsulError(Exception): pass

def consul_enabled():
    url = 'http://localhost:8500/v1/kv/downtime/service/goingest/node/%s' % platform.node()
    response = requests.get(url)
    if response.status_code == 200: # existence of the kv = disabled
        with open(cache_file, 'a'):
            os.utime(cache_file, None)
        return False
    elif response.status_code == 404:
        try:
            os.remove(cache_file)
        except OSError: 
            pass # the file doesn't exist
        return True
    else:
        raise ConsulError()

try:
    enabled = consul_enabled()
except Exception:
    print("Consul unreachable, using cache")
    try:
        enabled = not os.path.isfile(cache_file)
    except Exception:
        print("Cache unreachable, defaulting to enabled")
        enabled = True

print('Goingest enabled: %s' % enabled)

if enabled:
    sys.exit(0)
else:
    sys.exit(2)
