# This class configures an ingest server.

class ingest (
  $ingest_env = $ingest::params::ingest_env,
) inherits ingest::params {

  validate_re($ingest_env, [ '^staging$', '^production$' ])

  include twitch::codecs
  include twitch::flvmeta
  include twitch::packages
  include video::archives_dir

  realize(Package['snmp'])
  realize(Package['unzip'])
  realize(Package['pbuilder'])

  class { 'goingest':
    goingest_env => $ingest_env,
    bind_ip      => $::ipaddress_primary
  }

  file { '/usr/local/bin/goingest-enabled':
    ensure => present,
    owner  => 'root',
    group  => 'root',
    source => 'puppet:///modules/ingest/goingest-enabled.py',
  }

  consul::check{'goingest-enabled':
    check_script   => '/usr/local/bin/goingest-enabled',
    check_interval => '15s',
    require        => File['/usr/local/bin/goingest-enabled']
  }

  case $ingest_env {
    'staging': {
      ingest::ssl_certificate { 'wildcard_global-contribute-staging_live-video_net':
        sandstorm_key_prefix => "video/ingest/staging/${::pop}/wildcard_global-contribute-staging_live-video_net",
        cert_dir             => '/etc/goingest',
      }
    }
    default: {
      ingest::ssl_certificate { 'wildcard_global-contribute_live-video_net':
        sandstorm_key_prefix  => "video/ingest/production/${::pop}/wildcard_global-contribute_live-video_net",
        cert_dir              => '/etc/goingest',
        # set to true when Ingest deploys a service that needs *.global-contribute.live-video.net to ingest role hosts
        monitoring_use_nagios => false,
      }
    }
  }

}
