# define for installing a ssl_certificate for ingest hosts
define ingest::ssl_certificate (
  $ensure                = 'present',
  $sandstorm_key_prefix  = undef,
  $cert_dir              = undef,
  $monitoring_use_nagios = true,
) {
  include ingest

  validate_re($ensure, [ '^present$', '^absent$' ])
  validate_re($sandstorm_key_prefix, '^\w*[\/\w-]+\w*$')
  validate_re($cert_dir, '^\w*[\/\w-]+\w*$')

  twitch_ssl_certificate::certificate { "${title}.crt":
    ensure                => $ensure,
    cert_filesystem_path  => "${cert_dir}/${title}.crt",
    cert_contents         => join([
      "{{ key \"${sandstorm_key_prefix}/intermediate\" }}",
      "{{ key \"${sandstorm_key_prefix}/cert\" }}",
    ], "\n"),
    cert_owner            => 'root',
    cert_mode             => '0644',
    cert_group            => 'ssl-cert',
    monitoring_use_nagios => $monitoring_use_nagios,
  }

  twitch_sandstorm_agent::template { "${title}.key":
    ensure      => $ensure,
    destination => "${cert_dir}/${title}.key",
    key         => "${sandstorm_key_prefix}/key",
    owner       => 'nobody',
    mode        => '0640',
  }
}
