# == Class: ingest_proxy::params
#
class ingest_proxy::params {
  $nrdp_folder             = '/usr/local/nrdp/checkcache'
  $stats_prefix            = "stats.counters.ingest-proxy.${::pop}"
  $graphite_endpoint       = hiera('graphite_endpoint')
  $nagios_service_name     = 'ingest proxy anycast'
  $nginx_restart_command   = 'systemctl reload nginx'

  # staging anycast IP
  $anycast_ips             = {
    'lo:ingestproxy' => {
      'ipaddress' => '192.16.71.148',
    },
  }

  $findingest_lb            = 'findingest-staging.us-west-2.elasticbeanstalk.com'

  $loopback_ensure          = 'present'
  $enable_nginx             = false
  $enable_ssl               = false
  $enable_anycast           = false
  $enable_anycast_enforcer  = false
  $nginx_ssl_ciphers        = hiera('ciphers::default')
  $ingest_env               = pick($::twitch_environment, $twitch_environment, 'production')

}
