# interfaces facts
#

# Facter may return nothing for this, lets rescue nil
bond_interfaces = Facter.value('bonding_interfaces').split(',') rescue nil
# look for all the hardware network interfaces on system
# using Facter lookup
eth_ifaces = Facter.value('interfaces').split(',')
# remove any known bond interfaces from interface list
eth_ifaces -= [bond_interfaces].flatten

ifaces_100g = []
ifaces_25g = []
ifaces_10g = []
ifaces_1g = []

eth_ifaces.each do |nic|
  check_speed = Facter.value('maxspeed_' + nic).to_i
  # fact lookup each interface max speed
  case check_speed
  when 100000
    ifaces_100g << nic
  when 25000
    ifaces_25g << nic
  when 10000
    ifaces_10g << nic
  when 1000
    ifaces_1g << nic
  end
end

# add fact, comma separated list of 100g ethX devices
Facter.add('interfaces_100g') do
  setcode { ifaces_100g.compact.sort.join(',') }
end

# add fact, comma separated list of 25g ethX devices
Facter.add('interfaces_25g') do
  setcode { ifaces_25g.compact.sort.join(',') }
end

# add fact, comma separated list of 10g ethX devices
Facter.add('interfaces_10g') do
  setcode { ifaces_10g.compact.sort.join(',') }
end

# add fact, comma separated list of 1g ethX devices
Facter.add('interfaces_1g') do
  setcode { ifaces_1g.compact.sort.join(',') }
end

# add an easy lookup key for primary 100g nic
# return nil if mac address doesn't exist
Facter.add('macaddress_primary_100g') do
  setcode do
    mac = Facter.value("macaddress_#{ifaces_100g.first}")
    mac.nil? ? nil : mac.downcase
  end
end

# add an easy lookup key for primary 25g nic
# return nil if mac address doesn't exist
Facter.add('macaddress_primary_25g') do
  setcode do
    mac = Facter.value("macaddress_#{ifaces_25g.first}")
    mac.nil? ? nil : mac.downcase
  end
end

# add an easy lookup key for primary 10g nic
# return nil if mac address doesn't exist
Facter.add('macaddress_primary_10g') do
  setcode do
    mac = Facter.value("macaddress_#{ifaces_10g.first}")
    mac.nil? ? nil : mac.downcase
  end
end

# add mac address for 1g nics
Facter.add('macaddress_primary_1g') do
  setcode do
    mac = Facter.value("macaddress_#{ifaces_1g.first}")
    mac.nil? ? nil : mac.downcase
  end
end
