Puppet::Type.type(:ifstate).provide(:ifstate) do

  # returns hash of all interfaces in ifstate file
  def interfaces
    interfaces = Hash.new
    if File.exists?(file)
      File.open(file, 'r').each_line do |line|
        iface, ifalias = line.chomp.split('=')
        interfaces[iface] = ifalias
      end
    end
    interfaces
  end

  # method acts as a global variable
  def file
    '/var/run/network/ifstate'
  end

  def write_file(interfaces)
    File.open(file, 'w') do |f|
      interfaces.each do |k,v|
        f.write "%s=%s\n" % [k,v]
      end
    end
  end

  def create
    unless interfaces.has_key?(@resource[:name])
      write_file(interfaces.merge({
        @resource[:name] => @resource[:name]
      }))
    end
  end

  def destroy
    int = interfaces
    if int.has_key?(@resource[:name])
      int.delete(@resource[:name])
      write_file(int)
    end
  end

  def exists?
    interfaces.has_key?(@resource[:name])
  end

end
