Puppet::Type.newtype(:ifstate) do
  ensurable

  newparam(:interface) do
    isnamevar
    validate do |value|
      unless value =~ /^[a-z]+(?:\d*):\w+$/
        raise ArgumentError, "#{value} is not a valid interface alias"
      end
    end
  end

end
