# class interfaces
class interfaces {
  case $facts['osfamily'] {
    'Debian': {
      file { '/etc/network/interfaces':
        ensure => present,
        owner  => 'root',
        group  => 'root',
        mode   => '0644',
        source => "puppet:///modules/${module_name}/etc/network/interfaces",
      }

      $network_dirs = ['/etc/network', '/etc/network/interfaces.d']

      file { $network_dirs:
        ensure => directory,
        owner  => 'root',
        group  => 'root',
        mode   => '0755',
      }
    }
    default: {
    }
  }
}
