require 'spec_helper'
describe 'interfaces' do
  context 'with default values for all parameters on Ubuntu' do
    let(:facts) { {
      :osfamily => 'Debian',
    } }

    it { is_expected.to compile }
    it { is_expected.to have_interfaces__interface_resource_count(0) }
    it { is_expected.to contain_class('interfaces') }
    it { is_expected.to contain_file('/etc/network/interfaces').with({
      'ensure' => 'present',
      'owner' => 'root',
      'group' => 'root',
      'mode' => '0644',
    }) }
    it { is_expected.to contain_file('/etc/network/interfaces.d').with({
      'ensure' => 'directory',
      'owner' => 'root',
      'group' => 'root',
      'mode' => '0755',
    }) }
  end

  context 'with default values for all parameters on RedHat' do
    let(:facts) { {
      :osfamily => 'RedHat',
    } }

    it { is_expected.to compile }
    it { is_expected.to have_interfaces__interface_resource_count(0) }
    it { is_expected.to contain_class('interfaces') }
    it { is_expected.not_to contain_file('/etc/network/interfaces') }
    it { is_expected.not_to contain_file('/etc/network/interfaces.d') }
  end
end
