require 'spec_helper'

describe 'interfaces::interface' do
  let(:title) { 'team0' }
  let(:facts) { {
    :puppetversion => '3.8.5',
    :osfamily => 'Debian',
    :rubyversion => '2.4.1'
  } }

  it { should compile }
  it { is_expected.to contain_class('interfaces') }
  it { is_expected.to contain_file('/var/run/network/ifup.team0') }

  context 'with auto => true' do
    let(:params) { {'auto' => true} }

    it { is_expected.to contain_exec('ifup team0') }
  end

  context 'with ensure => absent and auto => true' do
    let(:params) { {'auto' => true, 'ensure' => 'absent'} }

    it { is_expected.to contain_exec('ifdown team0') }
  end

  context 'with alias' do
    let(:title) { 'foo0:1' }

    it { is_expected.to contain_ifstate('foo0:1') }
    it { is_expected.to contain_file('/var/run/network/ifup.foo0:1') }
  end
end
