# iprep_scores_import::dir
#
# Creates the directories configured for iprep_scores_import. All parent
# directories are created, and the directory itself is chown'ed to user nobody
# so that the unprivileged cronjob can write into it.
define iprep_scores_import::dir ($path) {
  exec { "mkdir_minus_p_${path}":
    command => "mkdir -p '${path}'",
    creates => $path,
    before  => File[$path]
  }

  file { $path:
    ensure => 'directory',
    path   => $path,
    owner  => 'nobody',
    group  => 'nogroup',
    mode   => '0755',
  }
}
