# enable obviously enables iptables
# rules is rules content as array or string
class iptables (
  $enable = $iptables::params::enable,
  $rules  = []
) inherits iptables::params {

  validate_bool($enable)

  case $enable {
    true: {
      $pkg_ensure       = 'present'
      $file_ensure      = 'present'
      $blacklist_ensure = 'absent'
    }
    false: {
      $pkg_ensure       = 'purged'
      $file_ensure      = 'absent'
      $blacklist_ensure = 'present'
    }
  }

  package { $package:
    ensure => $pkg_ensure
  }

  $header = [
    '##############################################################################',
    '# This file is mananged by puppet.  Do NOT edit on the server, your changes  #',
    '# will be blown away on the next puppet run.                                 #',
    '##############################################################################',
  ]

  $content = join(concat($header, any2array($rules)),"\n")

  file { '/etc/iptables.conf':
    ensure  => $file_ensure,
    content => "${content}\n",
    owner   => 'root',
    group   => 'root',
  }

  file { '/etc/network/if-pre-up.d/iptables':
    ensure  => $file_ensure,
    content => "#!/bin/sh\n/sbin/iptables-restore < /etc/iptables.conf\nexit 0\n",
    owner   => 'root',
    group   => 'root',
    mode    => '0544'
  }

  file { '/etc/modprobe.d/blacklist-iptables.conf':
    ensure => $blacklist_ensure,
    content => join([
      'alias ip6_tables off',
      'alias ip_tables off',
      'alias ip6table_filter off',
      'alias iptable_filter off',
    ], "\n"),
    mode    => '0644'
  }

  if $enable {
    # we need to load firewall rules if they change, and we're enabled
    exec { '/sbin/iptables-restore < /etc/iptables.conf':
      refreshonly => true,
      subscribe   => File['/etc/iptables.conf'],
      require     => Package[$package]
    }
  }
}
