#!/bin/bash

set -e

patterns=("eth*" "eno*" "enp*")

found=false
for pattern in "${patterns[@]}"; do
        interfaces=()
        numanode=0
        for filename in /sys/class/net/${pattern}; do
                statefile="${filename}/operstate"
                if [ ! -f $statefile ]; then
                        continue
                fi
                if [[ $(< $statefile) != "up" ]]; then
                        continue
                fi

                interface="${filename##*/}"
                interfaces+=($interface)

                numanode=$(< "${filename}/device/numa_node")
                echo "Found ${interface} on numa node ${numanode}..."
        done

        if ! [ -z "$interfaces" ]
        then
                echo "Configuring irq for ${interfaces[*]} on numa node ${numanode}..."
                set_irq_affinity_bynode.sh $numanode "${interfaces[@]}"
                found=true
        fi
done

if [ "${found}" != true ]; then
        echo "No network interfaces found!"
        exit 1
fi
