# Installs a service that configures IRQ affinity as a oneshot on boot.
class irq_affinity (
  $ensure = $irq_affinity::params::ensure,
  $script = $irq_affinity::params::script,
) inherits irq_affinity::params
{
  case $ensure {
    'present': {
      $service_ensure  = 'running'
      $service_enabled = true
    }
    'absent': {
      $service_ensure  = 'stopped'
      $service_enabled = false
    }
    default: {
      fail("${ensure} is not a valid value for \$ensure")
    }
  }
  $irq_affinity_service_path = '/usr/local/bin/irq_affinity_service.sh'
  service { 'irq_affinity':
    ensure    => $service_ensure,
    enable    => $service_enable,
    subscribe => [
      Twitch_systemd::Unit_file['irq_affinity.service'],
      File[$irq_affinity_service_path],
      Class['twitch_irqbalance'],
    ]
  }

  twitch_systemd::unit_file { 'irq_affinity.service':
    ensure  => $ensure,
    content => template("${module_name}/irq_affinity.service.erb"),
    require => File[$irq_affinity_service_path],
  }

  file { $irq_affinity_service_path:
    ensure => $ensure,
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    source => "puppet:///modules/${module_name}/${script}",
  }

}
