# kinesis_client #

This module installs the
[Amazon Kinesis Client Library](https://github.com/awslabs/amazon-kinesis-client). It
provides a method for running services under the KCL's
MultiLangDaemon.

## kinesis_client::consumer ##

Will write configuration files and a run script for running an
executable under the KCL MultiLangDaemon.

For example:

```
kinesis_client::consumer { "logger" :
  executable       => "/opt/twitch/messagelogger",
  stream_name      => "syslog-pipe",
  application_name => "messagelogger",
}
```

This will write a run script to
`/usr/local/amazon-kinesis-client/consumers/messagelogger/run.sh`
which will launch the MultiLangDaemon configured to run
/opt/twitch/messagelogger.

## kinesis_client::supervise ##

Will supervise the KCL MultiLangDaemon, configuring it to communicate
with an executable you specify, connected to a specified Kinesis
Stream and registered under an application name.

For example:

```
  kinesis_client::supervise { "aggregate-daemon" :
    executable       => "/opt/twitch/trace/current/bin/aggregate",
    stream_name      => "trace-events",
    application_name => "trace-aggregate-testing",
  }
```


