define kinesis_client::consumer (
  $executable,
  $stream_name,
  $application_name,
  $install_dir = '/usr/local/amazon-kinesis-client'
) {
  require kinesis_client

  validate_absolute_path($executable)
  validate_string($stream_name)
  validate_string($application_name)

  $appdir = "${install_dir}/consumers/${application_name}"
  validate_absolute_path($appdir)

  file { $appdir :
    ensure  => "directory",
    require => Class['kinesis_client']
  }

  file { "${appdir}/consumer.properties" :
    ensure => file,
    content => template("kinesis_client/consumer.properties.erb"),
    require => File[$appdir]
  }

  file { "${appdir}/commons-logging.properties" :
    ensure  => file,
    content => file("${module_name}/commons-logging.properties"),
    require => File[$appdir]
  }

  file { "${appdir}/run.sh" :
    ensure  => file,
    mode    => "+x",
    content => template("kinesis_client/run.sh.erb"),
    require => File[$appdir]
  }
}
