class libvmod_curl (
  $env  = $libvmod_curl::params::env,
  $repo = $libvmod_curl::params::repo,
) inherits libvmod_curl::params
{

  $consul_tags = $env ? {
    'canary' => [ $env, 'production' ],
    default  => [ $env ],
  }

  consul::service { 'libvmod-curl':
    consul_tags => $consul_tags,
  }

  courier::install { 'libvmod-curl':
    env     => $env,
    repo    => $repo,
    require => Consul::Service['libvmod-curl'],
  }
}
