#!/bin/sh
# THIS FILE IS AUTOMATICALLY DISTRIBUTED BY PUPPET.  ANY CHANGES WILL BE
# OVERWRITTEN.

if [ -f /var/lib/logrotate/status ]
then
  # Logrotate's status file occasionally gets in a corrupted state,
  # causing subsequent runs to fail. In order to prevent this from
  # happening we remove the offending lines from the status file.
  LOGROTATE_STATUS_SHA=$(sha256sum /var/lib/logrotate/status)

  # Match lines that follow the pattern:
  # "/path/to/log/file" yyyy-mm-dd
  LOGROTATE_STATUS_PATTERN='^\"[a-zA-Z0-9@\*\/\.\_\-]\+\"\ [0-9]\{4\}\-\([1-9]\|1[012]\)\-\([1-9]\|[12][0-9]\|3[01]\)'
  # Skip the first line of the file and delete any lines that
  # don't match the above pattern.
  sed -i "2,\${/$LOGROTATE_STATUS_PATTERN/!d}" /var/lib/logrotate/status

  if ! echo "$LOGROTATE_STATUS_SHA" | sha256sum -c > /dev/null 2>&1; then
    /usr/bin/logger -t logrotate "ALERT removed corrupted lines from /var/lib/logrotate/status"
  fi
fi
