# Fact: :logrotate_package
#
# Purpose: retrieve installed logrotate version
#

Facter.add(:logrotate_version) do
    setcode do
        osfamily = Facter.value('osfamily')
        case osfamily
        when "Debian"
            command='/usr/bin/dpkg-query -f \'${Status};${Version};\' -W logrotate 2>/dev/null'
            version = Facter::Util::Resolution.exec(command)
            if version =~ /.*install ok installed;([^;]+);.*/
                $1
            else
                nil
            end
        when "RedHat", "Suse"
            command='rpm -qa --qf "%{VERSION}" "logrotate"'
            version = Facter::Util::Resolution.exec(command)
            if version =~ /^(.+)$/
                $1
            else
                nil
            end
        else
            nil
        end
    end
end

