# logrotate config
class logrotate::config{

  $manage_cron_daily = $::logrotate::manage_cron_daily
  $config_daily      = $::logrotate::config_daily

  file{'/etc/logrotate.d':
    ensure => 'directory',
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

  file{'/usr/local/lib/logrotate':
    ensure => 'directory',
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

  file{'/usr/local/lib/logrotate/clean_status_file_hourly.sh':
    ensure =>  'file',
    owner  =>  'root',
    group  =>  'root',
    mode   =>  '0644',
    source =>  'puppet:///modules/logrotate/clean_status_file_hourly.sh',
  }

  file{'/usr/local/lib/logrotate/clean_status_file.sh':
    ensure => 'file',
    owner  => 'root',
    group  => 'root',
    mode   => '0644',
    source => 'puppet:///modules/logrotate/clean_status_file.sh',
  }

  if $manage_cron_daily {
    file{'/etc/cron.daily/logrotate':
      ensure => 'file',
      owner  => 'root',
      group  => 'root',
      mode   => '0555',
      source => 'puppet:///modules/logrotate/etc/cron.daily/logrotate',
    }
  }

  if is_hash($config_daily) {
    $custom_daily_config = {'/etc/logrotate.conf' => $config_daily}
    create_resources('logrotate::conf', $custom_daily_config)
  }

}
