# apply defaults
#
class logrotate::defaults{

  case $::osfamily {
    'Debian': {

      if !defined( Logrotate::Conf['/etc/logrotate.conf'] ) {
        if versioncmp($::lsbdistrelease, '14.04') >= 0 {
          logrotate::conf {'/etc/logrotate.conf':
            su_group => 'syslog',
            include_dir => '/etc/logrotate.d',
          }
        } else {
          logrotate::conf {'/etc/logrotate.conf':
            include_dir => '/etc/logrotate.d',
          }
        }
      }

      if !defined( Logrotate::Conf['/etc/logrotate-hourly.conf'] ) {
        if versioncmp($::lsbdistrelease, '14.04') >= 0 {
          logrotate::conf {'/etc/logrotate-hourly.conf':
            su_group     => 'syslog',
            include_dir  => '/etc/logrotate.d/hourly',
            rotate_every => 'UNDEFINED',
          }
        } else {
          logrotate::conf {'/etc/logrotate-hourly.conf':
            include_dir  => '/etc/logrotate.d/hourly',
            rotate_every => 'UNDEFINED',
          }
        }
      }

      Logrotate::Rule {
        missingok    => true,
        rotate_every => 'month',
        create       => true,
        create_owner => 'root',
        create_group => 'utmp',
        rotate       => '1',
      }

      if !defined( Logrotate::Rule['wtmp'] ) {
        logrotate::rule { 'wtmp':
            path        => '/var/log/wtmp',
            create_mode => '0664',
        }
      }
      if !defined( Logrotate::Rule['btmp'] ) {
        logrotate::rule { 'btmp':
          path        => '/var/log/btmp',
          create_mode => '0600',
        }
      }
    }
#    'Gentoo': {
#      if !defined( Logrotate::Conf['/etc/logrotate.conf'] ) {
#        logrotate::conf {'/etc/logrotate.conf':
#          dateext  => true,
#          compress => true,
#          ifempty  => false,
#          mail     => false,
#          olddir   => false,
#        }
#      }
#
#      Logrotate::Rule {
#        missingok    => true,
#        rotate_every => 'month',
#        create       => true,
#        create_owner => 'root',
#        create_group => 'utmp',
#        rotate       => '1',
#      }
#
#      if !defined( Logrotate::Rule['wtmp'] ) {
#        logrotate::rule { 'wtmp':
#            path        => '/var/log/wtmp',
#            missingok   => false,
#            create_mode => '0664',
#            minsize     => '1M',
#        }
#      }
#      if !defined( Logrotate::Rule['btmp'] ) {
#        logrotate::rule { 'btmp':
#            path        => '/var/log/btmp',
#            create_mode => '0600',
#        }
#      }
#    }
    'RedHat': {
      if !defined( Logrotate::Conf['/etc/logrotate.conf'] ) {
        logrotate::conf {'/etc/logrotate.conf': }
      }

      Logrotate::Rule {
        missingok    => true,
        rotate_every => 'month',
        create       => true,
        create_owner => 'root',
        create_group => 'utmp',
        rotate       => '1',
      }

      if !defined( Logrotate::Rule['wtmp'] ) {
        logrotate::rule { 'wtmp':
            path        => '/var/log/wtmp',
            create_mode => '0664',
            missingok   => false,
            minsize     => '1M',
        }
      }
      if !defined( Logrotate::Rule['btmp'] ) {
        logrotate::rule { 'btmp':
            path        => '/var/log/btmp',
            create_mode => '0600',
            minsize     => '1M',
        }
      }
    }
#    'SuSE': {
#      if !defined( Logrotate::Conf['/etc/logrotate.conf'] ) {
#        logrotate::conf {'/etc/logrotate.conf': }
#      }
#
#      Logrotate::Rule {
#        missingok    => true,
#        rotate_every => 'month',
#        create       => true,
#        create_owner => 'root',
#        create_group => 'utmp',
#        rotate       => '99',
#        maxage       => '365',
#        size         => '400k',
#      }
#
#      if !defined( Logrotate::Rule['wtmp'] ) {
#        logrotate::rule { 'wtmp':
#            path        => '/var/log/wtmp',
#            create_mode => '0664',
#            missingok   => false,
#        }
#      }
#
#      if !defined( Logrotate::Rule['btmp'] ) {
#        logrotate::rule { 'btmp':
#            path         => '/var/log/btmp',
#            create_mode  => '0600',
#            create_group => 'root',
#        }
#      }
#    }
    default: {
      if !defined( Logrotate::Conf['/etc/logrotate.conf'] ) {
        logrotate::conf {'/etc/logrotate.conf': }
      }
    }
  }
}
