class mcelog {

  if versioncmp($::lsbmajdistrelease, '18.04') < 0 {

    package{ 'mcelog':
      ensure => installed,
    }

    service{ 'mcelog':
      ensure  => running,
      enable  => true,
      require => Package['mcelog'],
    }

    logrotate::rule{ 'mcelog':
      ensure       => present,
      path         => '/var/log/mcelog',
      rotate_every => 'day',
      compress     => true,
      rotate       => 30,
      ifempty      => false,
      missingok    => true,
      copytruncate => true,
      create       => true,
      create_mode  => '0644',
      create_owner => 'root',
      create_group => 'root',
      olddir       => '/var/log/archive',
      require      => Package['mcelog'],
    }

  }

}
