# The milliner-class, when activated, defaults to ensuring the `latest` version
# of the milliner-package is installed.
#
# To remove the milliner-package give `absent` for the ensure param, run
# puppet, and then remove the milliner-class from the list of classes in the
# hiera spec.
class milliner (
  $ensure  = $milliner::params::ensure,
  $version = $milliner::params::version,
) inherits milliner::params {

  require twitch_amazon_ssm_agent

  # Set the package ensure parameter to absent or the version provided.
  case $ensure {
    present: {
      $ensure_pkg = $version
      $ensure_svc = running
      $enable_svc = true
      $enable_check = true
    }
    absent: {
      $ensure_pkg = absent
      $ensure_svc = stopped
      $enable_svc = false
      $enable_check = false
    }
    default: {
      fail('milliner::ensure must be present or absent')
    }
  }

  package { 'video-milliner':
    ensure      => $ensure_pkg,
    configfiles => 'replace',
  }

  interfaces::interface { 'lo:milliner':
    ensure    =>  absent,
    method    =>  'static',
    ipaddress =>  '169.254.169.254',
    auto      =>  true,
    before    =>  Service['video-milliner'],
  }

  # Create a check to forward milliner health status to nagios.
  if $enable_check {
    twitch_servicecheck::passive { 'video-milliner':
      command        => 'envoy-check --host 127.0.0.1 --port 4287',
      interval       => 1, # minutes between checks
      retry          => 2, # times to fail before reporting failure
      retry_interval => 1, # minutes between checks once reporting failure
    }
  }

  service { 'video-milliner':
    ensure  => $ensure_svc,
    enable  => $enable_svc,
    require => Package['video-milliner'],
  }
}
