#!/bin/bash

# wrapper that walks through the migration process
# Run in workingdir containing add_to_all_envs.sh. This will create its own subdir to work in.
# NOTE: This will push the module_migration_pr_branch branch to origin in control-repo,
# And will push the cleanup changes in the same branch in puppet-monolith (as done by add-to-all-envs)

starttime=$(date +%s)
mmprb='module_migration_pr_branch'
module=$1
gituri3='git@git.xarth.tv:video-puppet-thirdparty'
gituri='git@git.xarth.tv:video-puppet'
stage_vpm='video-puppet-master-08acdbe35654c6571.us-west-2.stage.puppet.live-video.a2z.com'

function error() {
    echo $1
    exit 1
}

function confirm() {
    if [[ -n "$2" ]] ; then
        cnfm=$2
    else
        cnfm=$(cat /dev/random | env LC_CTYPE=C tr -dc 'a-zA-Z0-9' |fold -w 5|head -1)
    fi
    c=''
    echo "${1}, confirm: ${cnfm}"
    while [[ "$c" != "$cnfm" ]] ; do
        read c
    done
}

[[ -z "${module}" ]] && errr "Usage: $0 <module>" 1

wd="migration_${module}_${starttime}"
mkdir $wd
pushd $wd

if [[ -d ../puppet-monolith.git ]] ; then
    pushd ../puppet-monolith.git
    git remote update
    popd
    git clone ../puppet-monolith.git
else
    git clone $gituri/puppet-monolith.git
fi

git clone $gituri/control-repo.git
module_uri="${gituri3}/${module}.git"
git clone $module_uri

#auto-version
if [ -f puppet-monolith/modules/$module/metadata.json ] ; then
    checkver=$(jq .version puppet-monolith/modules/$module/metadata.json|sed -e 's/"//g')
    tagvers=$(git ls-remote --tag --ref $module_uri '*'$checkver'*' --format | sed -e 's/.*refs\/tags\///')

    echo "Metadata in puppet-monolith module shows version ${checkver}, similar tags in new repo found these versions:"
    echo "$tagvers"
    echo "Enter the tag version to use or leave blank to follow 'production' branch:"
    while read x; do
        [[ -z "${x}" ]] && break
        if git ls-remote --tag --ref $module_uri "${x}"|grep "${x}" ; then
            ver=$x
            break
        fi
        echo 'Invalid tag, type it as it is listed please, try again.'
    done
fi

pushd $module
git checkout tags/$ver || error "Couldn't checkout $ver, check the repo and try again!"
diff -BEwbr ./ ../puppet-monolith/modules/$module/
popd

echo
confirm "Validate module diff" 'y'
echo

pushd control-repo || error "CD to control-repo failed"
echo "Calling ../../add_to_all_envs.sh ${module} -3 -v ${ver}"
../../add_to_all_envs.sh $module -3 -v $ver || error "add_to_all_envs.sh failed! check why and try again."

git checkout $mmprb
cat Puppetfile
echo
confirm "Verify $mmprb looks ok (above), "
echo

git push -u origin $mmprb
git checkout production
popd

pushd puppet-monolith
git remote set-url origin git@git.xarth.tv:video-puppet/puppet-monolith.git
git pull
git push -u origin $mmprb
popd

echo
confirm "Create a PR in control-repo for $mmprb but DO NOT MERGE YET " 'y'
echo

ssh $stage_vpm "sudo -u puppet /usr/local/bin/r10k -c /etc/r10k.yaml deploy environment $mmprb -p ; sudo -u puppet /usr/local/bin/r10k -c /etc/r10k.yaml deploy environment production -p ;while [[ ! -d /etc/puppet/environments/$mmprb ]] ; do sleep 5 ; echo -n . ; done ; echo ; diff -BEwbrq /etc/puppet/environments/production /etc/puppet/environments/$mmprb|grep -v '/\.git/'; echo; echo '************ verify environment diffs, hit <enter> ************'; echo; read x; diff -BEwbr /etc/puppet/environments/$mmprb/modules/$module /etc/puppet/environments/production/puppet_monolith/modules/$module 2>&1 | grep -v '\.git'|grep -v 'recursive directory loop'; echo; echo '********** compare module diffs, hit <enter> **********'; read x;  sudo puppet agent --enable ; sudo puppet agent -tv --environment $mmprb --server \$(hostname -f); sudo systemctl stop twitch-r10k-webhook.service; sudo puppet agent --disable 'module migrations' ; true" || \
    echo "######### WARNING! #########"$'\n'"SSH tests failed, please try by hand prior to continuing:"$'\n'"ssh $stage_vpm \"diff -BEwbrq /etc/puppet/environments/production /etc/puppet/environments/$mmprb|grep -v '/\.git/'; echo; echo '************ verify environment diffs, hit <enter> ************'; echo; read x; diff -BEwbr /etc/puppet/environments/$mmprb/modules/$module /etc/puppet/environments/$mmprb/puppet_monolith/modules/$module | grep -v '\.git'|grep -v 'recursive directory loop'; echo; echo '********** compare module diffs, hit <enter> **********'; read x;  sudo puppet agent -tv --environment $mmprb \$(hostname -f); \""

echo
confirm "Verify diffs and puppetrun above" 'y'
echo
echo "Now merge the control-repo PR, hit <enter>"
echo
read x
echo
pushd control-repo
branches=`git for-each-ref refs/remotes --format='%(refname:short)'|grep -v '^origin/HEAD'|grep -v '^origin/production$'|grep -v "origin/$mmprb"|sed -e 's/origin\///'`
git checkout $mmprb
cp Puppetfile "/tmp/${starttime}Puppetfile"
for branch in $branches ; do 
    git checkout $branch
    diff Puppetfile "/tmp/${starttime}Puppetfile"
done
git checkout production
rm "/tmp/${starttime}Puppetfile"
popd
confirm "Verify all Puppetfile diffs above:" 'y' 

echo
echo "Run this to finish"
echo
echo "cd ${wd}/control-repo; git push -u origin "${branches}"; cd ../../"
popd
echo "rm -rf ${wd}"
echo
echo "Mark $module as done"
echo "start: ${starttime} end $(date +%s)"
echo
