#!/bin/bash

# wrapper that walks through the migration process
# Run in workingdir containing add_to_all_envs1st.sh. This will create its own subdir to work in.
# NOTE: This will push the module_migration_pr_branch branch to origin in control-repo,
# And will push the cleanup changes in the same branch in puppet-monolith (as done by add-to-all-envs)

starttime=$(date +%s)
mmprb='module_migration_pr_branch'
modules=$@
gituri='git@git.xarth.tv:video-puppet'
stage_vpm='video-puppet-master-08acdbe35654c6571.us-west-2.stage.puppet.live-video.a2z.com'

# relative to being in $wd
mirror_dir='../puppet-monolith.git'

function error() {
    echo $1
    exit 1
}

function confirm() {
    if [[ -n "$2" ]] ; then
        cnfm=$2
    else
        cnfm=$(cat /dev/random | env LC_CTYPE=C tr -dc 'a-zA-Z0-9' |fold -w 5|head -1)
    fi
    c=''
    echo "${1}, confirm: ${cnfm}"
    while [[ "$c" != "$cnfm" ]] ; do
        read c
    done
}

wd="migration_dir_${starttime}"
mkdir $wd

pushd $wd

if [[ ! -d $mirror_dir ]] ; then
    pushd ..
    echo "cloning mirror repo puppet-monolith from remote"
    git clone --mirror $gituri/puppet-monolith.git
    popd
else
    echo 'using local mirror repo of puppet-monolith'
    pushd $mirror_dir
    git fetch --all --force
    git fetch --prune
    git gc
    git prune --expire=now
    popd
fi
mkdir monolith
pushd monolith
git clone ../$mirror_dir
popd

git clone $gituri/control-repo.git

popd
./module_pull.sh -t $starttime $@

pushd $wd

confirm "verify above modules look ok to push"
for mod in $modules ; do
    pushd $mod || error "Error pushing $mod"
    while ! git ls-remote $gituri/$mod.git >/dev/null 2>&1 ; do
        echo "Repo $gituri/$mod.git does not appear to exist? create and hit enter to continue"
        read
    done
    git push origin --all --force || echo "****  Error pushing $mod!! ****"
    popd
done

pushd control-repo || error "CD to control-repo failed"
for mod in $modules ; do
    echo "Calling ../../add_to_all_envs1st.sh ${mod}"
    ../../add_to_all_envs1st.sh $mod || error "add_to_all_envs1st.sh failed! check why and try again."
done 

git checkout $mmprb
cat Puppetfile
echo
confirm "Verify $mmprb looks ok (above), "
echo

git push -u origin $mmprb
git checkout production
popd

pushd monolith/puppet-monolith
# in case its a local-mirror checkout, switch to the remote origin and update before sending our changes
git remote set-url origin $gituri/puppet-monolith.git
git pull
git push -u origin $mmprb
popd

echo
confirm "Create a PR in control-repo for $mmprb but DO NOT MERGE YET " 'y'
echo

ssh $stage_vpm "sudo -u puppet /usr/local/bin/r10k -c /etc/r10k.yaml deploy environment $mmprb -p ; sudo -u puppet /usr/local/bin/r10k -c /etc/r10k.yaml deploy environment production -p ;while [[ ! -d /etc/puppet/environments/$mmprb ]] ; do sleep 5 ; echo -n . ; done ; echo ; diff -BEwbrq /etc/puppet/environments/production /etc/puppet/environments/$mmprb|grep -v '/\.git/'; echo; echo '************ verify environment diffs, (all new modules in $mmprb/modules/ and removed from production/puppet-monolith) hit <enter> ************'; echo; read x; sudo puppet agent --enable ; sudo puppet agent -tv --environment $mmprb --server \$(hostname -f); sudo systemctl stop twitch-r10k-webhook.service; sudo puppet agent --disable 'module migrations' ; true" || \
    echo "######### WARNING! #########"$'\n'"SSH tests failed, please try by hand prior to continuing:"$'\n'"ssh $stage_vpm \"diff -BEwbrq /etc/puppet/environments/production /etc/puppet/environments/$mmprb|grep -v '/\.git/'; echo; echo '************ verify environment diffs, hit <enter> ************'; echo; read x; sudo puppet agent -tv --environment $mmprb \$(hostname -f); \""

echo
confirm "Verify diffs and puppetrun above" 'y'
echo
echo "Now merge the control-repo PR, hit <enter>"
echo
read x
echo
pushd control-repo
branches=`git for-each-ref refs/remotes --format='%(refname:short)'|grep -v '^origin/HEAD'|grep -v '^origin/production$'|grep -v "origin/$mmprb"|sed -e 's/origin\///'`
git checkout $mmprb
cp Puppetfile "/tmp/${starttime}Puppetfile"
for branch in $branches ; do 
    git checkout $branch
    diff Puppetfile "/tmp/${starttime}Puppetfile"
done
git checkout production
rm "/tmp/${starttime}Puppetfile"
popd
confirm "Verify all Puppetfile diffs above:" 'y' 

echo
echo "Run this to finish"
echo
echo "pushd ${wd}/control-repo; git push -u origin "${branches}"; popd"
popd
echo "rm -rf ${wd}"
echo
echo "Mark $modules as done"
echo "start: ${starttime} end $(date +%s)"
echo
