#!/bin/bash
# Run prior to migratins to stop the r10k webhook receiver on all puppetmasters (enumerated here)
# Also disables puppet agent to prevent turning webhook back on
# Run after to re-enable things and tell r10k to update all environments

pm="video-puppet-master-000448f40122065a8.us-west-2.prod.puppet.live-video.a2z.com
video-puppet-master-006a22fa9fb65f61e.us-west-2.prod.puppet.live-video.a2z.com
video-puppet-master-012c29f354cae1488.us-west-2.prod.puppet.live-video.a2z.com
video-puppet-master-02cf9da09047e6f88.us-west-2.prod.puppet.live-video.a2z.com
video-puppet-master-08acdbe35654c6571.us-west-2.stage.puppet.live-video.a2z.com
video-puppet-master-067c5b5a5eeae2070.us-west-2.prod.puppet.live-video.a2z.com
video-puppet-master-07f54401f30ae773a.us-west-2.prod.puppet.live-video.a2z.com
video-puppet-master-0842304eb99d0a30e.us-west-2.prod.puppet.live-video.a2z.com
video-puppet-master-0a0bbc2435544b921.us-west-2.prod.puppet.live-video.a2z.com
video-puppet-master-0a72db25bb183c077.us-west-2.prod.puppet.live-video.a2z.com
video-puppet-master-0aef19beb20c959d8.us-west-2.prod.puppet.live-video.a2z.com
video-puppet-master-0afd82b4c3bdc6eab.us-west-2.stage.puppet.live-video.a2z.com
video-puppet-master-0c0d8139b8e6d3547.us-west-2.prod.puppet.live-video.a2z.com
video-puppet-master-0c4d6d79a14dec442.us-west-2.prod.puppet.live-video.a2z.com
video-puppet-master-0cb16ec3db27323aa.us-west-2.prod.puppet.live-video.a2z.com
video-puppet-master-0cb57302e5e3965cc.us-west-2.stage.puppet.live-video.a2z.com
video-puppet-master-0e56fe089f4072f47.us-west-2.prod.puppet.live-video.a2z.com
video-puppet-master-0e5b3126380ab185c.us-west-2.prod.puppet.live-video.a2z.com"

function usage() {
    echo "$0 (-a|-b|-f)"
    echo " -a  for pre-migrations (turns off webhook and puppet)"
    echo " -b  for post-migrations (runs full r10k deploy (-f), turns webhook and puppet back on)"
    echo " -f  to flush all changes via 'r10k deploy environment -p'"
    exit
}

function comm() {
    pssh -O StrictHostKeyChecking=no -t 0 -h <(echo "$pm") "$1"
}

while getopts "abf" opt ; do
    case "${opt}" in
        a)
            pre=1
            ;;
        b)
            post=1
            flush=1
            ;;
        f)
            flush=1
            ;;
        *)
            usage
            ;;
    esac
done

if [[ -n $pre ]] ; then
    comm "sudo puppet agent --disable 'stopping r10k webhook for a few migratins'"
    comm "sudo systemctl stop twitch-r10k-webhook.service"
fi
if [[ -n $flush ]] ; then
    comm "sudo -u puppet /usr/local/bin/r10k -v -c /etc/r10k.yaml deploy environment -p"
fi
if [[ -n $post ]] ; then
    comm "sudo systemctl start twitch-r10k-webhook.service"
    comm "sudo puppet agent --enable"
fi

