# Class NetRR External 
class netrr_ext (
  $template        = $netrr_ext::params::template,
  $consul_template = $netrr_ext::params::consul_template,
  $ospf_area       = $netrr_ext::params::ospf_area,
  $include_file    = $netrr_ext::params::include_file,
  $env             = $netrr_ext::params::env,
) inherits netrr_ext::params {

  bird::loopback { 'lo:1':
    ipaddress => $netrr_extip,
    auto => true,
  }

  bird::loopback { 'lo:2':
    ipaddress => $birdfeeder_extip,
    auto => true,
  }

  bird::loopback { 'lo:3':
    ipaddress => $birdpolicy_extip,
    auto => true,
  }

  consul::service { 'bird_netrr_consul':
    service_name => 'bird-netrr',
    port         => 179,
    consul_tags  => concat(["birdip=${birdfeeder_extip}"], $env),
  }

  bird::daemon { 'netrr_ext':
    ospf_area => $ospf_area,
    template  => $template,
  }

  bird::daemon { 'birdfeeder_ext':
    include_file    => $include_file,
    template        => $template_birdfeeder,
    consul_template => $consul_template,
  }

  bird::daemon { 'birdpolicy_ext':
    template => $template_birdpolicy,
  }
}
