# This is for netrr external
class netrr_ext::params {
  $template        = 'netrr_ext/bird_netrr_ext.erb'
  $template_birdfeeder       = 'netrr_ext/bird_netrr_ext_birdfeeder.erb'
  $template_birdpolicy       = 'netrr_ext/bird_netrr_ext_birdpolicy.erb'
  $consul_template = 'netrr_ext/consul_netrr_ext_downstreams.conf.ctpl.erb'
  $ospf_area       = hiera('ospf_area', '0.0.0.0')
  $include_file    = undef
  $env             = ['production']

  $ospf_map        = {
    'sjc02'          => {
      'netrr_extip'  => '10.255.127.51',
      'birdfeeder_extip' => '10.255.127.71',
      'birdpolicy_extip' => '10.255.127.61',
    },
  }

  $protocol_map = {
    'sjc02'          => 'bgp',
  }

  $netrr_extip = $ospf_map[$::pop]['netrr_extip']
  $birdfeeder_extip = $ospf_map[$::pop]['birdfeeder_extip']
  $birdpolicy_extip = $ospf_map[$::pop]['birdpolicy_extip']
}
