# Class NetRR External Fastpath
class netrr_ext_fastpath (
  $template        = $netrr_ext_fastpath::params::template,
  $consul_template = $netrr_ext_fastpath::params::consul_template,
  $ospf_area       = $netrr_ext_fastpath::params::ospf_area,
  $include_file    = $netrr_ext_fastpath::params::include_file,
  $env             = $netrr_ext_fastpath::params::env,
) inherits netrr_ext_fastpath::params {

  ## Because these are all defines in ANOTHER class, using templates
  ## from THIS class, all variables in this class are OUT OF SCOPE for those
  ## templates. Thus scope['netrr_ext_fastpath::params::$var'] must be used
  ## for all variables in this class' templates to actually work.
  ## This "just works" in puppet3 due to either bugs or the more lax scoping
  ## rules, but breaks in puppet4+
  ## This also means anything trying to override these values in the bird::
  ## defined types will NOT work without testing for both values and selecting
  ## one.

  bird::loopback { 'lo:1':
    ipaddress => $netrr_extip,
    auto      => true,
  }

  bird::loopback { 'lo:2':
    ipaddress => $birdfeeder_extip,
    auto      => true,
  }

  bird::loopback { 'lo:3':
    ipaddress => $birdpolicy_extip,
    auto      => true,
  }

  bird::loopback { 'lo:4':
    ipaddress => $netrr_extip_fastpath,
    auto      => true,
  }

  bird::loopback { 'lo:5':
    ipaddress => $birdfeeder_extip_fastpath,
    auto      => true,
  }

  consul::service { 'bird_netrr_consul':
    service_name => 'bird-netrr',
    port         => 179,
    consul_tags  => concat(["birdip=${birdfeeder_extip}"], $env),
  }

  consul::service { 'bird_netrr_consul_fp':
    service_name => 'bird-netrr-fp',
    port         => 179,
    consul_tags  => concat(["birdip=${birdfeeder_extip_fastpath}"], $env),
  }

  bird::daemon { 'netrr_ext':
    template  => $template_netrr_ext,
  }

  bird::daemon { 'birdfeeder_ext':
    include_file    => $include_file,
    template        => $template_birdfeeder_ext,
    consul_template => $consul_template,
  }

  bird::daemon { 'birdpolicy_ext':
    template => $template_birdpolicy_ext,
  }

  bird::daemon { 'netrr_ext_fastpath':
    template  => $template_netrr_ext_fastpath,
  }

  bird::daemon { 'birdfeeder_ext_fastpath':
    include_file    => $include_file,
    template        => $template_birdfeeder_ext_fastpath,
    consul_template => $consul_template,
  }
}
