# This is for Netrr external fastpath

class netrr_ext_fastpath::params {
  $template_netrr_ext                     = 'netrr_ext_fastpath/bird_netrr_ext.erb'
  $template_netrr_ext_fastpath            = 'netrr_ext_fastpath/bird_netrr_ext_fastpath.erb'
  $template_birdfeeder_ext                = 'netrr_ext_fastpath/bird_netrr_ext_birdfeeder.erb'
  $template_birdfeeder_ext_fastpath       = 'netrr_ext_fastpath/bird_netrr_ext_birdfeeder_fastpath.erb'
  $template_birdpolicy_ext                = 'netrr_ext_fastpath/bird_netrr_ext_birdpolicy.erb'
  $consul_template                        = 'netrr_ext_fastpath/consul_netrr_ext_fastpath_downstreams.conf.ctpl.erb'
  $ospf_area                              = hiera('ospf_area', '0.0.0.0')
  $include_file                           = undef
  $env                                    = ['production']

  $ospf_map        = {
    'pdx05'          => {
      'netrr_extip'          => '10.255.127.51',
      'netrr_extip_fastpath' => '10.255.127.1',
      'birdfeeder_extip'     => '10.255.127.71',
      'birdfeeder_extip_fastpath' => '10.255.127.11',
      'birdpolicy_extip'     => '10.255.127.61',
    },
    'cmh01'          => {
      'netrr_extip'          => '10.255.127.52',
      'netrr_extip_fastpath' => '10.255.127.2',
      'birdfeeder_extip'     => '10.255.127.72',
      'birdfeeder_extip_fastpath' => '10.255.127.12',
      'birdpolicy_extip'     => '10.255.127.62',
    },
    'lhr05'          => {
      'netrr_extip'          => '10.255.127.53',
      'netrr_extip_fastpath' => '10.255.127.3',
      'birdfeeder_extip'     => '10.255.127.73',
      'birdfeeder_extip_fastpath' => '10.255.127.13',
      'birdpolicy_extip'     => '10.255.127.63',
    },
    'sin01'          => {
      'netrr_extip'          => '10.255.127.54',
      'netrr_extip_fastpath' => '10.255.127.4',
      'birdfeeder_extip'     => '10.255.127.74',
      'birdfeeder_extip_fastpath' => '10.255.127.14',
      'birdpolicy_extip'     => '10.255.127.64',
    },
    'ord03'          => {
      'netrr_extip'          => '10.255.127.55',
      'netrr_extip_fastpath' => '10.255.127.5',
      'birdfeeder_extip'     => '10.255.127.75',
      'birdfeeder_extip_fastpath' => '10.255.127.15',
      'birdpolicy_extip'     => '10.255.127.65',
    },
  }

  $br_routers = {
  # NA brocade
  'br01.qro01' => { 'ip' => '52.223.249.175', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.qro01' => { 'ip' => '52.223.249.176', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  # NA cisco
  'br01.yto01' => { 'ip' => '52.223.249.147', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.yto01' => { 'ip' => '52.223.249.148', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.lax03' => { 'ip' => '52.223.249.133', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.lax03' => { 'ip' => '52.223.249.134', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.den01' => { 'ip' => '52.223.249.139', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.den01' => { 'ip' => '52.223.249.140', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.dfw02' => { 'ip' => '52.223.249.143', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.dfw02' => { 'ip' => '52.223.249.144', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.atl01' => { 'ip' => '52.223.249.137', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.atl01' => { 'ip' => '52.223.249.138', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.ord02' => { 'ip' => '199.9.248.53', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.ord02' => { 'ip' => '199.9.248.54', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.ord03' => { 'ip' => '99.181.99.129', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.ord03' => { 'ip' => '99.181.99.130', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.phx01' => { 'ip' => '199.9.248.3', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.phx01' => { 'ip' => '199.9.248.4', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.iad03' => { 'ip' => '52.223.249.153', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.iad03' => { 'ip' => '52.223.249.154', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.iad05' => { 'ip' => '99.181.99.197', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.iad05' => { 'ip' => '99.181.99.198', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.hou01' => { 'ip' => '52.223.249.159', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.hou01' => { 'ip' => '52.223.249.160', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.pdx01' => { 'ip' => '52.223.249.161', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.pdx01' => { 'ip' => '52.223.249.162', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.sea01' => { 'ip' => '199.9.248.5', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.sea01' => { 'ip' => '199.9.248.6', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.slc01' => { 'ip' => '52.223.249.165', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.slc01' => { 'ip' => '52.223.249.166', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.ymq03' => { 'ip' => '99.181.99.36', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.ymq03' => { 'ip' => '99.181.99.37', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.jfk04' => { 'ip' => '52.223.249.179', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.jfk04' => { 'ip' => '52.223.249.180', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.jfk06' => { 'ip' => '52.223.249.183', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.jfk06' => { 'ip' => '52.223.249.184', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.ord03' => { 'ip' => '99.181.99.129', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.ord03' => { 'ip' => '99.181.99.130', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  # EMEA brocade
  'br01.mrs01' => { 'ip' => '52.223.249.149', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.mrs01' => { 'ip' => '52.223.249.150', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.prg02' => { 'ip' => '52.223.249.167', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.prg02' => { 'ip' => '52.223.249.168', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  # EMEA cisco
  'br01.arn03' => { 'ip' => '199.9.248.9', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.arn03' => { 'ip' => '199.9.248.10', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.cdg02' => { 'ip' => '199.9.248.61', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.cdg02' => { 'ip' => '199.9.248.62', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.fra02' => { 'ip' => '52.223.249.131', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.fra02' => { 'ip' => '52.223.249.132', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.lhr03' => { 'ip' => '199.9.248.59', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.lhr03' => { 'ip' => '199.9.248.60', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.mad01' => { 'ip' => '52.223.249.141', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.mad01' => { 'ip' => '52.223.249.142', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.waw01' => { 'ip' => '199.9.248.49', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.waw01' => { 'ip' => '199.9.248.50', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.ams02' => { 'ip' => '199.9.248.57', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.ams02' => { 'ip' => '199.9.248.58', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.ams03' => { 'ip' => '99.181.99.195', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.ams03' => { 'ip' => '99.181.99.196', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.ber01' => { 'ip' => '52.223.249.163', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.ber01' => { 'ip' => '52.223.249.164', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.hel01' => { 'ip' => '52.223.249.173', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.hel01' => { 'ip' => '52.223.249.174', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.osl01' => { 'ip' => '52.223.249.181', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.osl01' => { 'ip' => '52.223.249.182', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.fra05' => { 'ip' => '99.181.99.185', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.fra05' => { 'ip' => '99.181.99.186', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.fra06' => { 'ip' => '99.181.99.187', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.fra06' => { 'ip' => '99.181.99.188', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.cph01' => { 'ip' => '99.181.99.135', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.cph01' => { 'ip' => '99.181.99.136', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  # APAC brocade
  'br01.sel01' => { 'ip' => '199.9.248.19', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.sel01' => { 'ip' => '199.9.248.20', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.tyo01' => { 'ip' => '199.9.248.29', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.tyo01' => { 'ip' => '199.9.248.30', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.hkg01' => { 'ip' => '199.9.248.27', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.hkg01' => { 'ip' => '199.9.248.28', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  # APAC cisco
  'br01.sin01' => { 'ip' => '52.223.249.129', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.sin01' => { 'ip' => '52.223.249.130', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.tpe01' => { 'ip' => '52.223.249.157', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.tpe01' => { 'ip' => '52.223.249.158', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.tpe03' => { 'ip' => '99.181.99.189', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.tpe03' => { 'ip' => '99.181.99.190', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.sel03' => { 'ip' => '199.9.248.177', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.sel03' => { 'ip' => '199.9.248.178', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  # OCEANIA brocade
  'br01.syd01' => { 'ip' => '199.9.248.45', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.syd01' => { 'ip' => '199.9.248.46', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  # LATAM cisco
  'br01.sao01' => { 'ip' => '52.223.249.135', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.sao01' => { 'ip' => '52.223.249.136', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br01.rio01' => { 'ip' => '52.223.249.145', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  'br02.rio01' => { 'ip' => '52.223.249.146', 'export' => 'empty_out', 'export_fastpath' => 'br_out',},
  }

  $cr_routers = {
  #Cisco CR - NA
  'cr01.cmh01' => { 'ip' => '99.181.99.131', 'export' => 'empty_out', 'export_fastpath' => 'cr_na_east_aws_pni_out',},
  'cr02.cmh01' => { 'ip' => '99.181.99.132', 'export' => 'empty_out', 'export_fastpath' => 'cr_na_east_aws_pni_out',},
  'cr03.cmh01' => { 'ip' => '99.181.99.153', 'export' => 'empty_out', 'export_fastpath' => 'cr_na_east_aws_pni_out',},
  'cr04.cmh01' => { 'ip' => '99.181.99.154', 'export' => 'empty_out', 'export_fastpath' => 'cr_na_east_aws_pni_out',},
  'cr01.sjc05' => { 'ip' => '99.181.99.191', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.sjc05' => { 'ip' => '99.181.99.192', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr01.sjc99' => { 'ip' => '99.181.99.205', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.sjc99' => { 'ip' => '99.181.99.206', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr01.pdx05' => { 'ip' => '99.181.99.167', 'export' => 'empty_out', 'export_fastpath' => 'cr_na_west_aws_pni_out',},
  'cr02.pdx05' => { 'ip' => '99.181.99.168', 'export' => 'empty_out', 'export_fastpath' => 'cr_na_west_aws_pni_out',},
  'cr03.pdx05' => { 'ip' => '99.181.99.169', 'export' => 'empty_out', 'export_fastpath' => 'cr_na_west_aws_pni_out',},
  'cr04.pdx05' => { 'ip' => '99.181.99.170', 'export' => 'empty_out', 'export_fastpath' => 'cr_na_west_aws_pni_out',},
  'cr01.iad06' => { 'ip' => '99.181.99.221', 'export' => 'empty_out', 'export_fastpath' => 'cr_na_east_aws_pni_out',},
  'cr02.iad06' => { 'ip' => '99.181.99.222', 'export' => 'empty_out', 'export_fastpath' => 'cr_na_east_aws_pni_out',},
  'cr03.iad06' => { 'ip' => '99.181.99.223', 'export' => 'empty_out', 'export_fastpath' => 'cr_na_east_aws_pni_out',},
  'cr04.iad06' => { 'ip' => '99.181.99.224', 'export' => 'empty_out', 'export_fastpath' => 'cr_na_east_aws_pni_out',},
  'cr01.qro02' => { 'ip' => '99.181.99.173', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.qro02' => { 'ip' => '99.181.99.174', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr01.for01' => { 'ip' => '99.181.99.0', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.for01' => { 'ip' => '99.181.99.1', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr01.mia05' => { 'ip' => '99.181.99.8', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.mia05' => { 'ip' => '99.181.99.9', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  #Cisco CR - EMEA
  'cr01.lhr04' => { 'ip' => '99.181.99.141', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.lhr04' => { 'ip' => '99.181.99.142', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr01.lhr05' => { 'ip' => '99.181.99.145', 'export' => 'empty_out', 'export_fastpath' => 'cr_emea_aws_pni_out',},
  'cr02.lhr05' => { 'ip' => '99.181.99.146', 'export' => 'empty_out', 'export_fastpath' => 'cr_emea_aws_pni_out',},
  'cr03.lhr05' => { 'ip' => '99.181.99.147', 'export' => 'empty_out', 'export_fastpath' => 'cr_emea_aws_pni_out',},
  'cr04.lhr05' => { 'ip' => '99.181.99.148', 'export' => 'empty_out', 'export_fastpath' => 'cr_emea_aws_pni_out',},
  'cr01.ams04' => { 'ip' => '99.181.99.231', 'export' => 'empty_out', 'export_fastpath' => 'cr_emea_aws_pni_out',},
  'cr02.ams04' => { 'ip' => '99.181.99.232', 'export' => 'empty_out', 'export_fastpath' => 'cr_emea_aws_pni_out',},
  'cr03.ams04' => { 'ip' => '99.181.99.233', 'export' => 'empty_out', 'export_fastpath' => 'cr_emea_aws_pni_out',},
  'cr04.ams04' => { 'ip' => '99.181.99.234', 'export' => 'empty_out', 'export_fastpath' => 'cr_emea_aws_pni_out',},
  'cr01.dus01' => { 'ip' => '99.181.99.213', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.dus01' => { 'ip' => '99.181.99.214', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr01.mil02' => { 'ip' => '99.181.99.209', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.mil02' => { 'ip' => '99.181.99.210', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr01.vie02' => { 'ip' => '99.181.99.247', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.vie02' => { 'ip' => '99.181.99.248', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr01.cdg10' => { 'ip' => '99.181.99.4', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.cdg10' => { 'ip' => '99.181.99.5', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr01.mrs02' => { 'ip' => '99.181.99.251', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.mrs02' => { 'ip' => '99.181.99.252', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  #Cisco CR - APAC
  'cr01.bkk01' => { 'ip' => '99.181.99.137', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.bkk01' => { 'ip' => '99.181.99.138', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr01.blr01' => { 'ip' => '99.181.99.16', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.blr01' => { 'ip' => '99.181.99.17', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr01.bom01' => { 'ip' => '99.181.99.237', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.bom01' => { 'ip' => '99.181.99.238', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr01.del01' => { 'ip' => '99.181.99.20', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.del01' => { 'ip' => '99.181.99.21', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr01.hkg06' => { 'ip' => '99.181.99.28', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.hkg06' => { 'ip' => '99.181.99.29', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr01.hyd01' => { 'ip' => '99.181.99.24', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.hyd01' => { 'ip' => '99.181.99.25', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr01.maa01' => { 'ip' => '99.181.99.241', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.maa01' => { 'ip' => '99.181.99.242', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr01.sel04' => { 'ip' => '99.181.99.32', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.sel04' => { 'ip' => '99.181.99.33', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr01.sin03' => { 'ip' => '99.181.99.122', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.sin03' => { 'ip' => '99.181.99.123', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr01.tyo03' => { 'ip' => '99.181.99.177', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.tyo03' => { 'ip' => '99.181.99.178', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr01.tyo05' => { 'ip' => '99.181.99.12', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.tyo05' => { 'ip' => '99.181.99.13', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  #Cisco CR - OCEANIA
  'cr01.syd02' => { 'ip' => '99.181.99.181', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  'cr02.syd02' => { 'ip' => '99.181.99.182', 'export' => 'empty_out', 'export_fastpath' => 'cr_out',},
  }

  $er_routers = {
  #Cisco ER - NA
  'er01.sjc05' => { 'ip' => '99.181.99.193', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.sjc05' => { 'ip' => '99.181.99.194', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er01.sjc99' => { 'ip' => '99.181.99.207', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.sjc99' => { 'ip' => '99.181.99.208', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er01.qro02' => { 'ip' => '99.181.99.175', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.qro02' => { 'ip' => '99.181.99.176', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er01.for01' => { 'ip' => '99.181.99.2', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.for01' => { 'ip' => '99.181.99.3', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er01.mia05' => { 'ip' => '99.181.99.10', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.mia05' => { 'ip' => '99.181.99.11', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  #Cisco ER - EMEA
  'er01.lhr04' => { 'ip' => '99.181.99.143', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.lhr04' => { 'ip' => '99.181.99.144', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er01.dus01' => { 'ip' => '99.181.99.215', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.dus01' => { 'ip' => '99.181.99.216', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er01.mil02' => { 'ip' => '99.181.99.211', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.mil02' => { 'ip' => '99.181.99.212', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er01.vie02' => { 'ip' => '99.181.99.249', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.vie02' => { 'ip' => '99.181.99.250', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er01.cdg10' => { 'ip' => '99.181.99.6', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.cdg10' => { 'ip' => '99.181.99.7', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er01.mrs02' => { 'ip' => '99.181.99.253', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.mrs02' => { 'ip' => '99.181.99.254', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  #Cisco ER - APAC
  'er01.bkk01' => { 'ip' => '99.181.99.139', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.bkk01' => { 'ip' => '99.181.99.140', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er01.blr01' => { 'ip' => '99.181.99.18', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.blr01' => { 'ip' => '99.181.99.19', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er01.tyo03' => { 'ip' => '99.181.99.179', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.tyo03' => { 'ip' => '99.181.99.180', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er01.maa01' => { 'ip' => '99.181.99.243', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.maa01' => { 'ip' => '99.181.99.244', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er01.bom01' => { 'ip' => '99.181.99.239', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.bom01' => { 'ip' => '99.181.99.240', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er01.del01' => { 'ip' => '99.181.99.22', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.del01' => { 'ip' => '99.181.99.23', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er01.hkg06' => { 'ip' => '99.181.99.30', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.hkg06' => { 'ip' => '99.181.99.31', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er01.sel04' => { 'ip' => '99.181.99.34', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.sel04' => { 'ip' => '99.181.99.35', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er01.tyo05' => { 'ip' => '99.181.99.14', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.tyo05' => { 'ip' => '99.181.99.15', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er01.hyd01' => { 'ip' => '99.181.99.26', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.hyd01' => { 'ip' => '99.181.99.27', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  #Cisco ER - OCEANIA
  'er01.syd02' => { 'ip' => '99.181.99.183', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  'er02.syd02' => { 'ip' => '99.181.99.184', 'export' => 'empty_out', 'export_fastpath' => 'empty_out'},
  }

  $ecr_routers = {
  # NA brocade
  # NA Cisco
  'ecr01.cmh01' => { 'ip' => '99.181.99.199', 'export' => 'empty_out', 'export_fastpath' => 'ecr_out',},
  'ecr02.cmh01' => { 'ip' => '99.181.99.200', 'export' => 'empty_out', 'export_fastpath' => 'ecr_out',},
  'ecr01.pdx05' => { 'ip' => '99.181.99.171', 'export' => 'empty_out', 'export_fastpath' => 'ecr_out',},
  'ecr02.pdx05' => { 'ip' => '99.181.99.172', 'export' => 'empty_out', 'export_fastpath' => 'ecr_out',},
  'ecr01.sjc05' => { 'ip' => '99.181.99.245', 'export' => 'empty_out', 'export_fastpath' => 'ecr_out',},
  'ecr02.sjc05' => { 'ip' => '99.181.99.246', 'export' => 'empty_out', 'export_fastpath' => 'ecr_out',},
  # EMEA Cisco
  'ecr01.lhr04' => { 'ip' => '99.181.99.151', 'export' => 'empty_out', 'export_fastpath' => 'ecr_out',},
  'ecr02.lhr04' => { 'ip' => '99.181.99.152', 'export' => 'empty_out', 'export_fastpath' => 'ecr_out',},
  'ecr01.ams04' => { 'ip' => '99.181.99.235', 'export' => 'empty_out', 'export_fastpath' => 'ecr_out',},
  'ecr02.ams04' => { 'ip' => '99.181.99.236', 'export' => 'empty_out', 'export_fastpath' => 'ecr_out',},
  }

  $netrr_extip = $ospf_map[$::pop]['netrr_extip']
  $netrr_extip_fastpath = $ospf_map[$::pop]['netrr_extip_fastpath']
  $birdfeeder_extip = $ospf_map[$::pop]['birdfeeder_extip']
  $birdfeeder_extip_fastpath = $ospf_map[$::pop]['birdfeeder_extip_fastpath']
  $birdpolicy_extip = $ospf_map[$::pop]['birdpolicy_extip']
}
