# Applies configuration files for NRDC.
#
class nrdc::config (
  $file = $nrdc::config_file,
) inherits nrdc {
  $dir_ensure = $nrdc::ensure ? {
    'present' => 'directory',
    default   => 'absent',
  }
  $_opts = join(join_keys_to_values(delete_undef_values({
    '--listen' => $nrdc::listen,
  }), '='), ' ')

  $_daemon_opts = $_opts ? {
    undef   => '',
    ''      => '',
    default => "DAEMON_OPTS=${_opts}",
  }

  file { $nrdc::defaults_file:
    ensure  => $nrdc::ensure,
    content => join(delete(flatten([
      "CONFIG_FILE=${file}",
      $_daemon_opts,
      $nrdc::env_vars,
    ]), ''), "\n"),
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
  }

  # Allow placing config file in one location, and reading it from another.
  # Useful when managing configs externally, such as with consul-template.
  file { $nrdc::config_file:
    ensure  => $nrdc::ensure,
    owner   => 'root',
    group   => 'root',
    mode    => '0664',
    content => template($nrdc::config_template),
  }

  # Keep the include_dir clean.
  file { $nrdc::include_dir:
    ensure  => $dir_ensure,
    recurse => true,
    purge   => true,
    force   => true,
  }
}
