# nrdc puppet module
#
class nrdc (
  $ensure          = present,
  $config_file     = $nrdc::params::config_file,
  $include_dir     = $nrdc::params::include_dir,
  $listen          = $nrdc::params::listen,
  $token           = $nrdc::params::token,
  $delay           = $nrdc::params::delay,
  $service_path    = $nrdc::params::service_path,
  $results_path    = $nrdc::params::results_path,
  $manage_service  = $nrdc::params::manage_service,
  $package_version = $nrdc::params::package_version,
  $hostname        = $nrdc::params::hostname,
  $config_template = $nrdc::params::config_template,
  $package_name    = $nrdc::params::package_name,
  $env_vars        = $nrdc::params::env_vars,
  $allowed_users   = $nrdc::params::allowed_users,
  $default_user    = $nrdc::params::default_user,
  $defaults_file   = $nrdc::params::defaults_file,
  $servicechecks   = undef,
  $receivers       = undef,
  $servers         = undef,
  $metrics         = undef,
) inherits nrdc::params {
  include nrdc::resources
  if $ensure == 'present' {
    anchor { '::nrdc::begin': }
    -> class { '::nrdc::install': }
    -> class { '::nrdc::config': }
    ~> class { '::nrdc::service': }
    -> anchor { '::nrdc::end': }
    Nrdc::Servicecheck <| |> -> Class['nrdc::config']
    Nrdc::Server <| |> ~> Class['nrdc::service']
    Nrdc::Metrics <| |> ~> Class['nrdc::service']
    Nrdc::Receiver <| |> ~> Class['nrdc::service']
  } else {
    anchor { '::nrdc::begin': }
    -> class { '::nrdc::service': }
    -> class { '::nrdc::config': }
    -> class { '::nrdc::install': }
    -> anchor { '::nrdc::end': }
  }
}
