# Installs NRDC and places initial configuration file.
#
class nrdc::install {
  include ::nrdc
  if $nrdc::ensure == 'present' {
    $package_ensure = $nrdc::package_version
    $dir_ensure = 'directory'
  } else {
    $package_ensure = 'absent'
    $dir_ensure = 'absent'
  }
  package { $nrdc::package_name:
    ensure => $package_ensure,
  }
  # Keep the service directory clean.
  # Files are placed here by nrdc::servicecheck.
  # Not in config.pp because this doesn't need to notify the service.
  file { $nrdc::service_path:
    ensure  => $dir_ensure,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    purge   => true,
    recurse => true,
    force   => true,
    require => Package[$nrdc::package_name],
  }
}
