# Allows arbitrary definition of metrics collectors for NRDC.
#
define nrdc::metrics (
  $host          = join(values_at(split($name, ':'), 0)),
  $port          = join(values_at(split($name, ':'), 1)),
  $timeout       = '5s',
  $interval      = '1m',
  $template_path = 'nrdc/metrics.erb',
  $filename      = join([regsubst($name, '[?/&: ]', '_', 'G'), '.conf']),
) {
  include ::nrdc

  ensure_resource('file', "${nrdc::include_dir}/${filename}", {
    ensure  => pick($nrdc::ensure, 'absent'),
    content => template($template_path),
    mode    => '0644',
    owner   => 'root',
    group   => 'root',
  })
}
