# NRDC Puppet Module Default Parameters
#
class nrdc::params {
  # You should know what you're doing if you change the config file path.
  $config_file       = '/etc/nrdc/nrdc.conf'
  $include_dir       = '/etc/nrdc/conf.d'
  $listen            = '127.0.0.1:5668'
  $token             = 'hackme'
  $delay             = '45s'
  $package_name      = 'nrdc'
  $package_version   = 'latest'
  $manage_service    = true
  $results_path      = '/var/lib/nrdc/checkresults'
  $service_path      = '/var/lib/nrdc/services.d'
  $allowed_users     = [ 'nobody' ]
  $default_user      = 'nobody'
  case $::osfamily {
    'RedHat': {
      $defaults_file = '/etc/sysconfig/nrdc'
    }
    default: {
      $defaults_file = '/etc/default/nrdc'
    }
  }
  # Leaving this empty will allow NRDC to find the hostname automatically.
  $hostname          = ''
  # Using a proper path makes writing service checks slightly better.
  $env_vars          = ['PATH=/bin:/usr/bin:/usr/lib/nagios/plugins']

  # In case you want to do things alternatively. Pass in your own template.
  $config_template   = 'nrdc/nrdc.conf.erb'
}
