# Allows arbitrary definition of results receivers for NRDC.
#
define nrdc::receiver (
  $url              = $name,
  $http_vars        = '',
  $method           = 'POST',
  $http_data_var    = 'XMLDATA',
  $content_type     = 'application/x-www-form-urlencoded',
  $template_file    = '/etc/nrdc/nrdp.template.xml',
  $timeout          = '5s',
  $interval         = '5m',
  $template_data    = '',
  $replace_linefeed = '\\n',
  $template_path    = 'nrdc/receiver.erb',
  $filename         = join([regsubst($name, '[?/&: ]', '_', 'G'), '.conf']),
  $expected_code    = 200,
) {
  include ::nrdc

  ensure_resource('file', "${nrdc::include_dir}/${filename}", {
    ensure  => pick($nrdc::ensure, 'absent'),
    content => template($template_path),
    mode    => '0644',
    owner   => 'root',
    group   => 'root',
  })
}
